/*
 * Decompiled with CFR 0.152.
 */
package com.alexander.mutantmore.events;

import com.alexander.mutantmore.config.MutantBlazeCommonConfig;
import com.alexander.mutantmore.config.MutantMoreGroupedOptionsCommonConfig;
import com.alexander.mutantmore.config.MutantShulkerCommonConfig;
import com.alexander.mutantmore.config.MutantWitherSkeletonCommonConfig;
import com.alexander.mutantmore.init.EntityTypeInit;
import com.alexander.mutantmore.interfaces.INaturallySpawningMutant;
import java.util.Random;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="mutantmore", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class SpawnMutantsEvent {
    public static Random random = new Random();

    @SubscribeEvent
    public static void replaceMobs(LivingSpawnEvent.SpecialSpawn event) {
        if (((Boolean)MutantWitherSkeletonCommonConfig.spawns_naturally.get()).booleanValue() || ((Boolean)MutantMoreGroupedOptionsCommonConfig.mutant_spawning_on.get()).booleanValue()) {
            SpawnMutantsEvent.maybeReplaceMobWithMutant(event.getEntity(), EntityType.f_20497_, (EntityType)EntityTypeInit.MUTANT_WITHER_SKELETON.get(), event.getSpawnReason(), (Integer)MutantWitherSkeletonCommonConfig.natural_spawn_chance.get());
        }
        if (((Boolean)MutantShulkerCommonConfig.spawns_naturally.get()).booleanValue() || ((Boolean)MutantMoreGroupedOptionsCommonConfig.mutant_spawning_on.get()).booleanValue()) {
            SpawnMutantsEvent.maybeReplaceMobWithMutant(event.getEntity(), EntityType.f_20521_, (EntityType)EntityTypeInit.MUTANT_SHULKER.get(), event.getSpawnReason(), (Integer)MutantShulkerCommonConfig.natural_spawn_chance.get());
        }
        if (((Boolean)MutantBlazeCommonConfig.spawns_naturally.get()).booleanValue() || ((Boolean)MutantMoreGroupedOptionsCommonConfig.mutant_spawning_on.get()).booleanValue()) {
            SpawnMutantsEvent.maybeReplaceMobWithMutant(event.getEntity(), EntityType.f_20551_, (EntityType)EntityTypeInit.MUTANT_BLAZE.get(), event.getSpawnReason(), (Integer)MutantBlazeCommonConfig.natural_spawn_chance.get());
        }
    }

    public static void maybeReplaceMobWithMutant(Mob mobToReplace, EntityType<?> onlyReplaceType, EntityType<?> mutantType, MobSpawnType spawnReason, int chanceToReplace) {
        if (chanceToReplace > 0 && mobToReplace.m_6095_() == onlyReplaceType && mobToReplace.m_217043_().m_188503_(chanceToReplace) == 0 && !mobToReplace.f_19853_.f_46443_) {
            System.out.print("\r\ntrying to convert " + mobToReplace.m_7755_() + "to mutant");
            Mob spawnedMutant = mobToReplace.m_21406_(mutantType, false);
            ForgeEventFactory.onLivingConvert((LivingEntity)mobToReplace, (LivingEntity)spawnedMutant);
            for (EquipmentSlot equipmentslot : EquipmentSlot.values()) {
                ItemStack itemstack = mobToReplace.m_6844_(equipmentslot);
                if (itemstack.m_41619_()) continue;
                spawnedMutant.m_8061_(equipmentslot, itemstack.m_41777_());
                spawnedMutant.m_21409_(equipmentslot, 0.0f);
            }
            if (spawnedMutant instanceof INaturallySpawningMutant) {
                ((INaturallySpawningMutant)spawnedMutant).onMutantSpawned(spawnReason);
            }
        }
    }
}

